using System;
using Server.Items;

namespace Server.Items
{
	public class LightweightShortbow : MagicalShortbow
	{
		public override int LabelNumber{ get{ return 1073510; } } // lightweight shortbow

		[Constructable]
		public LightweightShortbow() : base()
		{
			Balanced = true;
		}

		public LightweightShortbow( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.WriteEncodedInt( 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadEncodedInt();
		}
	}
}